(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     42669,       1218]*)
(*NotebookOutlinePosition[     43397,       1243]*)
(*  CellTagsIndexPosition[     43353,       1239]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Series de Fourier", "Title"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Recuerda que la serie de Fourier de una funci\[OAcute]n ",
  StyleBox["T",
    FontSlant->"Italic"],
  "-peri\[OAcute]dica integrable ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es la serie de funciones  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_0/
              2 + \[Sum]\+\(k \[GreaterSlantEqual] 1\)\((a\_k\ \(cos(
                      2  \[Pi]\ k\ t/T)\)\  + \ 
                  b\_k\ \(sen(2\ \[Pi]\ k\ t/T)\))\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde los coeficientes ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  "y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  "se llaman coeficientes de Fourier reales de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" y ",
    FontSlant->"Italic"],
  "viene dados por:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox[\(a\_k\),
                FontWeight->"Bold"], 
              StyleBox["=",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(2\/T\),
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                    FontSize->14,
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox[\(f(t)\),
                      FontWeight->"Bold"], 
                    StyleBox[\(cos(2  \[Pi]\ k\ t/T)\),
                      FontWeight->"Bold"], 
                    StyleBox[\(\[DifferentialD]t\),
                      FontWeight->"Bold"], 
                    StyleBox["     ",
                      FontWeight->"Bold"], 
                    RowBox[{"(", 
                      StyleBox[\(k \[GreaterEqual] 0\),
                        FontWeight->"Bold"], 
                      StyleBox[")",
                        FontWeight->"Bold"]}]}]}]}]}], 
            StyleBox["   ",
              FontWeight->"Bold"], "\[IndentingNewLine]", 
            RowBox[{
              StyleBox[\(b\_k\),
                FontWeight->"Bold"], 
              StyleBox["=",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(2\/T\),
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                    FontSize->14,
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox[\(f(t)\),
                      FontWeight->"Bold"], 
                    StyleBox[\(sen(2  \[Pi]\ k\ t/T)\),
                      FontWeight->"Bold"], 
                    StyleBox[\(\[DifferentialD]t\),
                      FontWeight->"Bold"], 
                    StyleBox["      ",
                      FontWeight->"Bold"], 
                    RowBox[{"(", 
                      StyleBox[\(k \[GreaterEqual] 1\),
                        FontWeight->"Bold"], 
                      StyleBox[")",
                        FontWeight->"Bold"]}]}]}]}]}]}]}], 
        TraditionalForm]]],
  "\nlos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  "se llaman coeficientes coseno y los ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  " coefiecientes seno de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Equivalentemente, podemos escribir dicha serie en la forma ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(c\_k\),
          FontWeight->"Bold"], TraditionalForm]]],
  " son los coeficientes de Fourier complejos de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "y ",
  "vienen dados por:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox[\(c\_k\),
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox[\(1\/T\),
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                  FontSize->14,
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[\(f(t)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(e\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
                    FontWeight->"Bold"], 
                  StyleBox[\(\[DifferentialD]t\),
                    FontWeight->"Bold"], 
                  StyleBox["     ",
                    FontWeight->"Bold"], 
                  RowBox[{"(", 
                    StyleBox[\(k \[Element] \[DoubleStruckCapitalZ]\),
                      FontWeight->"Bold"], 
                    StyleBox[")",
                      FontWeight->"Bold"]}], 
                  StyleBox["   ",
                    FontWeight->"Bold"]}]}]}]}]}], TraditionalForm]]]
}], "Text",
  TextAlignment->Left],

Cell["La funci\[OAcute]n", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{"  ", 
        RowBox[{
          StyleBox[\(\(S\_N\)(t)\),
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox[\(\[Sum]\+\(k = \(-N\)\)\%N\),
                FontSize->9,
                FontWeight->"Bold"], 
              StyleBox[\(c\_k\ e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox[\(a\_0/2\),
                FontWeight->"Bold"], 
              StyleBox["+",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[\(\[Sum]\+\(k = 1\)\%N\),
                  FontSize->16,
                  FontWeight->"Bold"], 
                
                StyleBox[\((a\_k\ \(cos(2  \[Pi]\ k\ t/T)\)\  + \ 
                      b\_k\ \(sen(2\ \[Pi]\ k\ t/T)\))\),
                  FontWeight->"Bold"]}]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama el polinomio de Fourier de orden N de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Al calcular los coeficientes de una serie de Fourier es frecuente que \
aparezcan las expresiones Sin[n\[Pi]], Cos[n\[Pi]], Exp[\[ImaginaryI]\[Pi]n], \
Exp[-\[Iota]\[Pi]n], ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\))\)\^n\)]],
  " que conviene sustituir por sus correspondientes valores que dependen de \
la paridad de n. Para ello vamos a definir una funci\[OAcute]n que nos dice \
en algunos casos sencillos cuando una expresi\[OAcute]n simb\[OAcute]lica es \
par o impar. Lo que vamos a hacer es a\[NTilde]adir algunas definiciones a \
las funciones EvenQ[expr] y OddQ[expr]."
}], "Text"],

Cell[BoxData[{
    \(impar[i_] := OddQ[i]\), "\[IndentingNewLine]", 
    \(par[i_] := EvenQ[i]\), "\[IndentingNewLine]", 
    \(impar[
        i_\ j_] := \(\(impar[i]\)\(\ \)\(&&\)\(\ \)\(impar[j]\)\(\ \)\( (*\ 
          un\ producto\ es\ impar\ si\ ambos\ factores\ son\ impares\ *) \)\)\
\), "\[IndentingNewLine]", 
    \(par[
        i_\ j_] := \ \(\(par[i]\)\(\ \)\(||\)\(\ \)\(par[j]\)\(\ \)\( (*\ 
          un\ producto\ es\ par\ si\ alguno\ de\ los\ factores\ es\ par\ *) \
\)\)\), "\[IndentingNewLine]", 
    \(impar[i_ + j_] := 
      impar[i]\  && \ 
          par[j]\  || \ \(\(par[i]\)\(\ \)\(&&\)\(\ \)\(impar[
            j]\)\(\ \)\( (*\ 
            una\ suma\ es\ impar\ si\ los\ dos\ sumandos\ tienen\ distinta\ \
paridad\ *) \)\)\), "\[IndentingNewLine]", 
    \(par[i_ + j_] := 
      par[i]\  && \ 
          par[j]\  || \ \(\(impar[i]\)\(\ \)\(&&\)\(\ \)\(impar[
            j]\)\(\ \)\)\), "\[IndentingNewLine]", 
    \( (*\ 
      una\ suma\ es\ par\ si\ los\ dos\ sumandos\ tienen\ la\ misma\ paridad\ \
*) \)}], "Input"],

Cell["\<\
Ahora vamos a definir unas reglas de sustituci\[OAcute]n apropiadas (el orden \
en que escriben no es indifirente).\
\>", "Text"],

Cell[BoxData[
    \(\(TrigId = {Cos[\[Pi]\ n_?Integer] \[RuleDelayed] \((\(-1\))\)\^n, 
          Sin[\[Pi]\ n_?Integer] \[RuleDelayed] 0, 
          Exp[\[ImaginaryI]\ \[Pi]\ n_?
                  Integer] \[RuleDelayed] \((\(-1\))\)\^n, 
          Exp[\(-\[ImaginaryI]\)\ \[Pi]\ n_?
                  Integer] \[RuleDelayed] \((\(-1\))\)\^n, \((\(-1\))\)^
              n_?impar \[RuleDelayed] \(-1\), \((\(-1\))\)^
              n_?par \[RuleDelayed] 
            1, \((\(-1\))\)^\((n_?
                    impar\ \ m_)\) \[RuleDelayed] \ \((\(-1\))\)^\((m + 
                  1)\), \((\(-1\))\)^
              n_ \[RuleDelayed] \((\(-1\))\)\^n};\)\)], "Input"],

Cell[TextData[{
  "Observa c\[OAcute]mo funcionan estas reglas. Supongamos que obtenemos ",
  Cell[BoxData[
      \(TraditionalForm\`b\_k = \(4\ Sin[\(k\ \[Pi]\)\/2]\^2\)\/\(k\ \
\[Pi]\)\)]],
  ". Para simplificar este resultado podemos hacerlo como sigue."
}], "Text"],

Cell[BoxData[{
    \(b[k_] := \(4\ Sin[\(k\ \[Pi]\)\/2]\^2\)\/\(k\ \[Pi]\)\), "\
\[IndentingNewLine]", 
    \(Simplify[b[k] /. TrigId, 
      k \[Element] \ Integers]\ \), "\[IndentingNewLine]", 
    \(Simplify[b[2  k] /. TrigId, k \[Element] \ Integers]\  (*\ 
      para\ aplicar\ las\ reglas\ tienes\ que\ especificar\ que\ k\ es\ un\ \
entero\ *) \), "\[IndentingNewLine]", 
    \(Simplify[b[2  k + 1] /. TrigId, 
      k \[Element] \ Integers]\), "\[IndentingNewLine]", 
    \(Clear[b]\)}], "Input"],

Cell["Por ejemplo 3n puede ser par o impar. Observa lo que pasa:", "Text"],

Cell[BoxData[
    \(Simplify[\((\(-1\))\)^\((3  n)\) /. TrigId, 
      n \[Element] \ Integers]\)], "Input"],

Cell[TextData[{
  "Te aconsejo que tomes algunas precauciones al usar estas reglas y que \
compruebes cualquier resultado que no te convenza. Te aconsejo \
tambi\[EAcute]n que compruebes siempre el resultado para ",
  Cell[BoxData[
      \(TraditionalForm\`a\_0\)]],
  "."
}], "Text"],

Cell["\<\
Para que te sirva dse ayuda en esta pr\[AAcute]ctica te indico con un ejemplo \
una forma posible de proceder.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejemplo", "Subsection"],

Cell[TextData[{
  "Calcula los coeficientes de Fourier reales de la funci\[OAcute]n \"onda \
cuadrada\" de per\[IAcute]odo 1 que toma el valor -1 para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/2 \[LessEqual] t < 0\)]],
  " y toma el valor 1 para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t < 1/2\)]],
  ". Haz una animaci\[OAcute]n en la que aparezca la grafica de la funci\
\[OAcute]n y las gr\[AAcute]ficas de sus polinomios de Fourier de \
\[OAcute]rdenes 2k-1 para ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] 10\)]],
  " en el intervalo [-3/2,3/2]. ",
  "Finalmente representa gr\[AAcute]ficamente el espectro de amplitudes y el \
espectro de fases."
}], "Text"],

Cell["\<\
Defino la funci\[OAcute]n en el intervalo [-3/2,3/2] aunque por ahora no voy \
a usar esta definici\[OAcute]n.\
\>", "Text"],

Cell[BoxData[{
    \(f[t_] := \(-1\) /; \(-1\)/2 \[LessEqual] t < 
          0\), "\[IndentingNewLine]", 
    \(f[t_] := 1 /; 0 \[LessEqual] t < 1/2\), "\[IndentingNewLine]", 
    \(f[t_] := 
      f[t - 1] /; 1/2 \[LessEqual] t < 3/2\), "\[IndentingNewLine]", 
    \(f[t_] := 
      f[t + 1] /; \(-3\)/2 \[LessEqual] 
          t < \(-1\)/2\), "\[IndentingNewLine]", 
    \( (*\ otra\ forma\ de\ definir\ la\ funci\[OAcute]n\ f[x_] := 
        If[Mod[x, 1] >  .5, 1, \(-1\)]\ *) \)}], "Input"],

Cell[TextData[{
  "Defino comandos que calculan de forma simb\[OAcute]lica los coeficientes y \
los simplifican hasta donde pueden ser simplifiados directamente. Observa que \
como debo integrar una funci\[OAcute]n definida a trozos he partido el \
intervalo de integraci\[OAcute]n en dos mitades y en cada una de ellas he \
sustituido la funci\[OAcute]n por suvalor en la misma (si no lo haces as\
\[IAcute] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede darte problemas). "
}], "Text"],

Cell[BoxData[{
    \(a[k_] := \(a[k] = 
        Simplify[
          2 \((Integrate[\(-Cos[2  \[Pi]\ k\ t]\), {t, \(-1\)/2, 0}] + 
                  Integrate[Cos[2  \[Pi]\ k\ t], {t, 0, 1/2}])\) /. TrigId, 
          k \[Element] \ Integers]\)\), "\[IndentingNewLine]", 
    \(b[k_] := \(b[k] = 
        Simplify[
          2 \((Integrate[\(-Sin[2  \[Pi]\ k\ t]\), {t, \(-1\)/2, 0}] + 
                  Integrate[Sin[2  \[Pi]\ k\ t], {t, 0, 1/2}])\) /. TrigId, 
          k \[Element] \ Integers]\)\)}], "Input"],

Cell[BoxData[
    \(\(\({a[0]/2, a[k], b[k]}\)\(\ \)\( (*\ 
      calculamos\ los\ coefiecientes\ observa\ que\ b[
          k]\ no\ puede\ simplificarse\ directamente\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Simplify[{a[0]/2, b[2  k], b[2  k + 1]} /. TrigId, 
      k \[Element] \ Integers]\)\(\ \)\( (*\ 
      para\ simplificar\ b[k]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(polinomios = 
        Table[a[0]/
              2 + \[Sum]\+\(k = 1\)\%n\((a[k]\ Cos[2\ k\ \[Pi]\ t] + \ 
                  b[k]\ Sin[2\ k\ \[Pi]\ t])\), {n, 1, 20, 2}];\)\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{f[t], Evaluate[polinomios[\([k]\)]]}, {t, \(-3\)/2, 3/2}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .5]}], {k, 1, 10}]\)], "Input"],

Cell[TextData[{
  "Para representar los espectros de amplitud y de fases debes recordar la \
relaci\[OAcute]n entre los coefiecientes complejos de Fourier y los \
coeficientes seno y coseno que viene dada por:\n\t\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`c\_n = \(a\_n\  - \ \[ImaginaryI]\ b\_n\)\/2\ , \ 
      c\_\(-n\) = \(a\_n\  + \ \[ImaginaryI]\ b\_n\)\/2\)]],
  "\nRecuerda que el espectro de una se\[NTilde]al cuya serie de Fourier \
compleja es ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto de puntos ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". El espectro de amplitudes es el conjunto  ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, Abs[c\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " y el espectro de fases es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, Arg[c\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " dichos conjuntos suelen representarse por segmentos de l\[IAcute]nea que \
unen los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((n/T, 0)\)\)]],
  " con los puntos del espectro correspondiente. Aqu\[IAcute] tienes unas \
funciones que te ayudar\[AAcute]n a representarlos."
}], "Text"],

Cell[BoxData[{
    \(\(\(sptamp[p_, q_, period_] := 
      Table[{k/period, 
          Abs[If[k \[Element] Integers\  && \ 
                k \[GreaterEqual] 0, \((a[k] - \[ImaginaryI]\ b[k])\)/
                2. , \((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, 
          p, q, 1}]\)\(\[IndentingNewLine]\)
    \) (*\ construye\ el\ espectro\ de\ amplitudes\ para\  - p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\[IndentingNewLine]", 
    \(\(\(sptfases[p_, q_, period_] := 
      Table[{k/period, 
          Which[N[a[k]] \[Equal] N[b[k]] \[Equal] 0, 0, 
            k \[Element] Integers\  && \ k \[GreaterEqual] 0, 
            Arg[\((a[k] - \[ImaginaryI]\ b[k])\)/2. ], 
            k \[Element] Integers\  && \ k \[LessEqual] \(-1\), 
            Arg[\((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, p, q, 
          1}]\)\(\[IndentingNewLine]\)
    \) (*\ construye\ el\ espectro\ de\ fases\ para\  - p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\[IndentingNewLine]", 
    \(SpectrumAmplitudesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptamp[p, q, period], 
            Join[{Hue[0], 
                PointSize[
                  0.07/Log[
                      3.  + Length[
                          sptamp[p, q, period]]]]}, \((Point[#1] &)\) /@ 
                sptamp[p, q, period]]}, opts]]\[IndentingNewLine] (*\ 
      representa\ el\ espectro\ de\ amplitudes\ para\  - p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\[IndentingNewLine]", 
    \(SpectrumFasesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptfases[p, q, period], 
            Join[{Hue[0], 
                PointSize[
                  0.07/Log[
                      3.  + Length[
                          sptfases[p, q, period]]]]}, \((Point[#1] &)\) /@ 
                sptfases[p, q, period]]}, opts]]\), "\[IndentingNewLine]", 
    \( (*\ representa\ el\ espectro\ de\ fases\ para\  - p \[LessEqual] 
        k \[LessEqual] q\ *) \)}], "Input"],

Cell[BoxData[
    \(\(SpectrumAmplitudesPlot[\(-20\), 20, 1, 
        PlotRange \[Rule] {\(- .1\),  .8}, Axes \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    \(\(SpectrumFasesPlot[\(-20\), 20, 1, PlotRange \[Rule] All, 
        Axes \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    \(Show[GraphicsArray[{%%, %}]]\)], "Input"],

Cell[TextData[{
  "Es bueno que sepas que",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " tienen comandos espec\[IAcute]ficos para calcular los coeficientes de \
Fourier reales y complejos as\[IAcute] como polinomios de Fourier."
}], "Text"],

Cell[BoxData[
    \(<< Calculus`FourierTransform`\)], "Input"],

Cell[BoxData[
    \(Information[FourierCosCoefficient, LongForm \[Rule] False]\)], "Input"],

Cell[BoxData[
    \(Information[FourierTrigSeries, LongForm \[Rule] False]\)], "Input"],

Cell[TextData[{
  "Vamos a usar estos comandos. Para ello, es necesario redifinir la funci\
\[OAcute]n en el intervalo [-1/2,1/2]. Esto puede hacerse con el comando \
UnitStep[x] (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    \(\(\(Plot[
      UnitStep[x] - UnitStep[\(-x\)], {x, \(-1\)/2, 1/2}]\)\(;\)\(\ \)\( (*\ 
      como\ puedes\ ver\ coincide\ con\ f\ \(\(en\)\(\ \)\([\)\(\(-1\)/2, 
          1/\(\(2\)\([\)\(\ \)\)\)\)*) \)\)\)], "Input"],

Cell[BoxData[
    \(FourierSinCoefficient[UnitStep[x] - UnitStep[\(-x\)], x, k]\)], "Input"],

Cell[BoxData[
    \(FourierTrigSeries[UnitStep[x] - UnitStep[\(-x\)], x, 10]\)], "Input"],

Cell[TextData[{
  "En los ejercicios debes definir t\[UAcute] los comandos que calculen los \
coeficientes de Fourier. No uses los comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que no son precisamente excelentes y con frecuencia requieren ajustar \
algunos par\[AAcute]metros y redefinir la funci\[OAcute]n en el intervalo \
apropiado."
}], "Text"],

Cell[BoxData[
    \(\(\(FourierSinCoefficient[f[x], x, k]\)\(\ \)\( (*\ 
      as\[IAcute]\ est\[AAcute]\ definido\ este\ comando\ *) \)\)\)], "Input"],

Cell["\<\
Bueno, ya est\[AAcute] bien, ahora te toca a ti. No olvides representar gr\
\[AAcute]ficamente en los ejercicios que siguen el espectro de amplitudes y \
el espectro de fases.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  "Calcula los coeficientes de Fourier reales de la funci\[OAcute]n  de per\
\[IAcute]odo 1 que es igual a ",
  StyleBox["t",
    FontSlant->"Italic"],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t < 1\)]],
  ". Haz una animaci\[OAcute]n en la que aparezca la grafica de la funci\
\[OAcute]n y las gr\[AAcute]ficas de sus polinomios de Fourier de \
\[OAcute]rdenes 2k-1 para ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] 10\)]],
  " en el intervalo [-2,2]. Justifica la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%\[Infinity]\((\(-1\))\)\^\(k + \
1\)\/\(\((2\ k - 1)\)\(\ \)\) = \[Pi]\/4\)]],
  ".\nSugerencia: Para representar gr\[AAcute]ficamente la funci\[OAcute]n \
considerada puede ser \[UAcute]til usar el comando Mod[x,1] (consulta la \
ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Si empiezas haciendo un Clear[\"Global`*\"]  no olvides volver a \
evaluar las dos primeras celdas de este cuaderno si quieres volverlas a \
usar."
}], "Text"],

Cell[BoxData[
    \(\(\(Clear["\<Global`*\>"]\)\(\ \)\( (*\ 
      no\ olvides\ volver\ a\ evaluar\ las\ dos\ primeras\ celdas\ de\ este\ \
cuaderno\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(a[k_] := \(a[k] = 
        Simplify[2  Integrate[t*Cos[2  \[Pi]\ k\ t], {t, 0, 1}] /. TrigId, 
          k \[Element] \ Integers]\)\), "\[IndentingNewLine]", 
    \(b[k_] := \(b[k] = 
        Simplify[2  Integrate[t*Sin[2  \[Pi]\ k\ t], {t, 0, 1}] /. TrigId, 
          k \[Element] \ Integers]\)\)}], "Input"],

Cell[BoxData[
    \({a[0]/2, a[k], b[k]}\)], "Input"],

Cell[BoxData[
    \(Simplify[{a[0]/2, a[k], b[k]} /. TrigId, 
      k \[Element] Integers]\)], "Input"],

Cell[BoxData[
    \(\(polinomios = 
        Table[a[0]/
              2 + \[Sum]\+\(k = 1\)\%n\((a[k]\ Cos[2\ k\ \[Pi]\ t] + \ 
                  b[k]\ Sin[2\ k\ \[Pi]\ t])\), {n, 1, 20, 2}];\)\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{f[t], Evaluate[polinomios[\([k]\)]]}, {t, \(-2\), 2}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .5]}], {k, 1, 10}]\)], "Input"],

Cell[TextData[{
  "Por tanto ",
  Cell[BoxData[
      FormBox[
        RowBox[{"t", "=", 
          RowBox[{\(1\/2\), "-", 
            
            FormBox[\(\[Sum]\+\(k = 1\)\%\[Infinity]\( 
                      1\/\(k\ \[Pi]\)\) \(sen(2  \[Pi]\ k\ t)\)\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 < t < 1\)]],
  ". En particular para t=1/4 se deduce que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(1\/4 = \(\[Sum]\+\(k = 1\)\%\[Infinity]\( 
                  1\/\(k\ \[Pi]\)\) \(sen(\[Pi]\ k\ /
                    2)\) = \(\[Sum]\+\(k = 1\)\%\[Infinity]\( 
                    1\/\(\((2\ k - 1)\) \[Pi]\)\) \(sen(\(\[Pi](2\ k - 1)\)\ /
                    2)\) = \(\[Sum]\+\(k = 1\)\%\[Infinity]\( 
                      1\/\(\((2\ k - 1)\)\ \[Pi]\)\) \(sen(\[Pi]\ k - \[Pi]\ /
                        2)\) = \(\(-\(\[Sum]\+\(k = 1\)\%\[Infinity]\( 
                          1\/\(\((2\ k - 
                                1)\)\ \[Pi]\)\) \(cos(\[Pi]\ k)\)\)\) = \
\[Sum]\+\(k = 1\)\%\[Infinity]\((\(-1\))\)\^\(k + 1\)\/\(\((2\ k - 1)\)\ \
\[Pi]\)\)\)\)\)\)\)\)]],
  "\npor tanto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%\[Infinity]\((\(-1\))\)\^\(k + \
1\)\/\(\((2\ k - 1)\)\(\ \)\) = \[Pi]\/4\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell[TextData[{
  "Calcula los coeficientes de Fourier reales de la funci\[OAcute]n  de per\
\[IAcute]odo 2\[Pi] que es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`t\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \ \[Pi]\)]],
  ". Justifica la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n = 1\)\%\[Infinity]\((\(-1\))\)\^\(n + \
1\)\/n\^2 = \[Pi]\^2\/12\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[{
    \(a[k_] := \(a[k] = 
        Simplify[\(1\/\[Pi]\) 
              Integrate[t\^2*Cos[k\ t], {t, \(-\[Pi]\), \[Pi]}] /. TrigId, 
          k \[Element] \ Integers]\)\), "\[IndentingNewLine]", 
    \(b[k_] := \(b[k] = 
        Simplify[\(1\/\[Pi]\) 
              Integrate[t\^2*Sin[k\ t], {t, \(-\[Pi]\), \[Pi]}] /. TrigId, 
          k \[Element] \ Integers]\)\)}], "Input"],

Cell[BoxData[
    \({a[0]/2, a[k], b[k]}\)], "Input"],

Cell[BoxData[
    \(Simplify[{a[0]/2, a[k], b[k]} /. TrigId, 
      k \[Element] \ Integers]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Subsection"],

Cell[TextData[{
  "En este ejercicio se considera (",
  "la extensi\[OAcute]n peri\[OAcute]dica de) una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "definida en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  StyleBox["\na)",
    FontWeight->"Bold"],
  " Define funciones A[f_,n_,{var_,a_,b_}] y B[f_,n_,{var_,a_,b_}] que \
calculen simb\[OAcute]licamente los coeficientes seno y coseno \
n-\[EAcute]simos de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Define funciones NA[f_,n_,{var_,a_,b_}] y NB[f_,n_,{var_,a_,b_}] que \
calculen num\[EAcute]ricamente los coeficientes seno y coseno \
n-\[EAcute]simos de ",
  StyleBox["f.",
    FontSlant->"Italic"],
  "\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n  PoliFourier[f_,N_,{t_,a_,b_}] que calcule \
simb\[OAcute]licamente el polinomio de fourier de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " ",
  "Define una funci\[OAcute]n  NPoliFourier[f_,N_,{t_,a_,b_}] que calcule num\
\[EAcute]ricamente el polinomio de fourier de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". \nSugerencias: Si vas a usar estas funcioes para calcular tablas de \
polinomios de Fourier es \[UAcute]til que las definas de forma que almacenen \
los resultados que vayan calculando (esto lleva consigo la obligaci\[OAcute]n \
de hacer un Clear[\"Global`*\"] cuando quieras cambiar de funci\[OAcute]n). \
Para el apartado b) es muy conveniente usar las opciones AccuracyGoal",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "4  y el comando Chop (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). En los apartados c) y d) puedes usar el s\[IAcute]mbolo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%N\)]],
  " para definir los polinomios de Fourier pero no te lo aconsejo: es mucho \
mejor usar los comandos Plus@@Table[ ] (para el significado del comando @@ \
consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ").",
  "\n",
  "Observaci\[OAcute]n. No creas que los comandos as\[IAcute] definidos van a \
calcular los coeficientes de Fourier de cualquier funci\[OAcute]n. En \
particular, si una funci\[OAcute]n est\[AAcute] definida a trozos o se hace \
infinita en alg\[UAcute]n punto es posible que tengas que retocarlos para esa \
funci\[OAcute]n concreta."
}], "Text"],

Cell[BoxData[{
    \(A[f_, n_, {var_, a_, b_}] := \(A[f, n, {var, a, b}] = 
        Simplify[
          2\/\(b - a\)\ \(\[Integral]\_a\%b\((Cos[\(2\ n\ \[Pi]\ \
intvar\)\/\(b - a\)]\ f /. \[InvisibleSpace]var \[Rule] 
                        intvar)\) \[DifferentialD]intvar\) \
/. \[InvisibleSpace]TrigId, 
          Assumptions \[Rule] n \[Element] \ Integers]\)\), "\n", 
    \(B[f_, n_, {var_, a_, b_}] := \(B[f, n, {var, a, b}] = 
        Simplify[\(\(\(2\)\(\ \)\)\/\(b - 
                    a\)\) \(\[Integral]\_a\%b\((Sin[\(2\ n\ \[Pi]\ intvar\)\/\
\(b - a\)]\ f /. \[InvisibleSpace]var \[Rule] 
                        intvar)\) \[DifferentialD]intvar\) \
/. \[InvisibleSpace]TrigId, 
          Assumptions \[Rule] n \[Element] \ Integers]\)\)}], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[{
    \(NA[f_, n_, {var_, a_, b_}] := \(NA[f, n, {var, a, b}] = 
        Chop[2\/\(b - a\)\ NIntegrate[
              Cos[\(2\ n\ \[Pi]\ intvar\)\/\(b - a\)]\ f \
/. \[InvisibleSpace]var \[Rule] intvar, {intvar, a, b}, 
              AccuracyGoal -> 4]]\)\), "\n", 
    \(NB[f_, n_, {var_, a_, b_}] := \(NB[f, n, {var, a, b}] = 
        Chop[2\/\(b - a\)\ NIntegrate[
              Sin[\(2\ n\ \[Pi]\ intvar\)\/\(b - a\)]\ f \
/. \[InvisibleSpace]var \[Rule] intvar, {intvar, a, b}, 
              AccuracyGoal -> 4]]\)\)}], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(PoliFourier[f_, 
        N_, {var_, a_, b_}] := \[IndentingNewLine]A[f, 0, {var, a, b}]/2 + 
        Plus @@ Table[
            A[f, m, {var, a, b}]\ Cos[\(2\ m\ \[Pi]\ var\)\/\(b - a\)] + 
              B[f, n, {var, a, b}]\ Sin[\(2\ n\ \[Pi]\ var\)\/\(b - a\)], {m, 
              1, N}]\)], "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(NPoliFourier[f_, N_, {var_, a_, b_}] := 
      NA[f, 0, {var, a, b}]/2 + 
        Plus @@ Table[
            NA[f, m, {var, a, b}]\ Cos[\(2\ m\ \[Pi]\ var\)\/\(b - a\)] + 
              NB[f, m, {var, a, 
                    b}]\ Sin[\(2\ m\ \[Pi]\ var\)\/\(b - a\)], {m, 1, 
              N}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Subsection"],

Cell[TextData[{
  "a",
  StyleBox[")",
    FontWeight->"Bold"],
  " Utiliza las funciones definidas en el ejercicio anterior para calcular \
simb\[OAcute]licamente los coeficientes de Fourier reales de la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(t\)\(|\)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\), 1]\)\)]],
  ". Calcula sus primeros 10 polinomios de Fourier.\nb",
  StyleBox[")",
    FontWeight->"Bold"],
  " Deduce que  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n = 1\)\%\[Infinity] 1\/\((2  n - 1)\)\^2 \
= \[Pi]\^2\/8\)]],
  ".  A partir de esta igualdad y de la obtenida en el ejercicio 2, deduce \
que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n = 1\)\%\[Infinity] 1\/n\^2 = \[Pi]\^2\/6\
\)]],
  ".\n",
  StyleBox["c) ",
    FontWeight->"Bold"],
  "Utiliza las funciones definidas en el ejercicio anterior para calcular num\
\[EAcute]ricamente los primeros 5 polinomios de Fourier de orden par de la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`Sin[t\^2]\)]],
  " en el intervalo [-\[Pi],\[Pi]] y repres\[EAcute]ntalos \
gr\[AAcute]ficamente junto con la funci\[OAcute]n en el intervalo [-\[Pi],\
\[Pi]]."
}], "Text"],

Cell[BoxData[
    \(Simplify[{A[Abs[x], 0, {x, \(-1\), 1}]/2, A[Abs[x], k, {x, \(-1\), 1}], 
          B[Abs[x], k, {x, \(-1\), 1}]} /. TrigId, 
      k \[Element] \ Integers]\)], "Input"],

Cell[BoxData[
    \({A[Abs[x], 0, {x, \(-1\), 1}]/2, A[Abs[x], 2  k, {x, \(-1\), 1}], 
      A[Abs[x], 2  k - 1, {x, \(-1\), 1}]}\)], "Input"],

Cell[BoxData[
    \(Table[
      NPoliFourier[Sin[t\^2], k, {t, \(-\[Pi]\), \[Pi]}], {k, 1, 20, 
        2}]\)], "Input"],

Cell[BoxData[
    \(\(Plot[{Sin[
            t\^2], \(Out[
              6]\)[\([5]\)]}, {t, \(-\[Pi]\), \[Pi]}];\)\)], "Input"],

Cell[BoxData[
    \(Plot[Pi^2/4 - \((Abs[x] - \[Pi]/2)\)^2, {x, \(-\[Pi]\), \[Pi]}, 
      PlotStyle \[Rule] Hue[ .65], PlotRange \[Rule] {\(- .1\), 2.7}, 
      Background \[Rule] RGBColor[1, 1, 0.75]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Subsection"],

Cell[TextData[{
  "En este ejercicio se considera (la extensi\[OAcute]n peri\[OAcute]dica de) \
una funci\[OAcute]nf definida en un intervalo [a,b]\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n c[f_,k_,{var_,a_,b_}] que calcule \
simb\[OAcute]licamente los coeficientes complejos de Fourier de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Define funciones  una funci\[OAcute]n Nc[f_,k_,{var_,a_,b_}] que calcule \
num\[EAcute]ricamente los coeficientes complejos de Fourier de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n ComplexPoliFourier[f_,N_,{t_,a_,b_}] que \
calcule simb\[OAcute]licamente el polinomio de fourier con coeficientes \
complejos de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n NComplexPoliFourier[f_,N_,{t_,a_,b_}] que \
calcule num\[EAcute]ricamente el polinomio de fourier con coeficientes \
complejos de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["e)",
    FontWeight->"Bold"],
  " Calcula simb\[OAcute]licamente los coeficientes de Fourier complejos de \
las funciones: ",
  Cell[BoxData[
      \(TraditionalForm\`1 - t\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^2/4 - \((Abs[t] - \[Pi]/2)\)\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\nf)",
  StyleBox[" ",
    FontWeight->"Bold"],
  "Calcula num\[EAcute]ricamente el polinomio de Fourier de orden 20 con \
coeficientes de Fourier complejos de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`Cos[t\^2]\)]],
  " en el intervalo [-\[Pi],\[Pi]].\nObservaciones / Sugerencias: las mismas \
que para el ejercicio 3."
}], "Text"],

Cell[BoxData[
    \(c[f_, k_, {var_, a_, b_}] := \(c[f, k, {var, a, b}] = 
        Simplify[\(1\/\(b - 
                    a\)\) \(\[Integral]\_a\%b\((\[ExponentialE]\^\(-\(\(2\ k\ \
\[Pi]\ \[ImaginaryI]\ intvar\)\/\(b - a\)\)\)\ f /. \[InvisibleSpace]var \
\[Rule] intvar)\) \[DifferentialD]intvar\) /. \[InvisibleSpace]TrigId, 
          Assumptions \[Rule] k \[Element] \ Integers]\)\)], "Input"],

Cell[BoxData[
    \(Nc[f_, k_, {var_, a_, b_}] := \(Nc[f, k, {var, a, b}] = 
        Chop[\(1\/\(b - a\)\) 
            NIntegrate[\[ExponentialE]\^\(-\(\(2\ k\ \[Pi]\ \[ImaginaryI]\ \
intvar\)\/\(b - a\)\)\)\ f /. \[InvisibleSpace]var \[Rule] intvar, {intvar, 
                a, b}, AccuracyGoal \[Rule] 4]]\)\)], "Input"],

Cell[BoxData[
    \(ComplexPoliFourier[f_, N_, {var_, a_, b_}] := 
      Plus @@ \([Table[
            c[f, k, {var, a, 
                  b}] \[ExponentialE]\^\(\(2\ k\ \[Pi]\ \[ImaginaryI]\ \
var\)\/\(b - a\)\), {k, \(-N\), N}]]\)\)], "Input"],

Cell[BoxData[
    \(NComplexPoliFourier[f_, N_, {var_, a_, b_}] := 
      Plus @@ Table[
          Nc[f, k, {var, a, 
                b}]*\[ExponentialE]\^\(\(2\ k\ \[Pi]\ \[ImaginaryI]\ \
var\)\/\(b - a\)\), {k, \(-N\), N}]\)], "Input"],

Cell[BoxData[
    \(\(\(c[1 - t\^2, k, {t, 0, 1}]\)\(\ \)\( (*\ 
      observa\ como\ c[\(-k\)]\ es\ el\ conjugado\ de\ c[
          k]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(c[\[Pi]\^2/4 - \((Abs[t] - \[Pi]/2)\)\^2, 
      k, {t, \(-\[Pi]\), \[Pi]}]\)\(\ \)\( (*\ 
      como\ es\ una\ funci\[OAcute]n\ par\ sus\ coefiecientes\ son\ reales\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(NComplexPoliFourier[1 - t\^2, 20, {t, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(ComplexPoliFourier[1 - t\^2, 20, {t, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NComplexPoliFourier[Cos[t\^2], 20, {t, \(-\[Pi]\), \[Pi]}]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Serie de Fourier seno y serie de Fourier coseno", "Section"],

Cell[TextData[{
  "Recuerda que si ",
  StyleBox["f es ",
    FontSlant->"Italic"],
  "una funci\[OAcute]n definida e integrable en el intervalo} [0,L]. Podemos \
extender ",
  StyleBox["f",
    FontSlant->"Italic"],
  " al intervalo [-L,L] de dos formas distintas:\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x) = \(\(-\)\(f(\(-x\))\)\(\ \)\)\)]],
  "si ",
  Cell[BoxData[
      \(TraditionalForm\`\(-L\) \[LessEqual] x < 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x) = f(x)\)]],
  " si  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x < L\)]],
  "\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(f\_2\)(x)\)\(=\)\(f(\(-x\))\)\(\ \)\)\)]],
  "si ",
  Cell[BoxData[
      \(TraditionalForm\`\(-L\) \[LessEqual] x < 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_2\)(x) = f(x)\)]],
  " si  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x < L\)]],
  "\nEs claro que ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " es impar y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " es par y coinciden con ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [0,L]. La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " es llamada la extensi\[OAcute]n impar de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " es llamada la extensi\[OAcute]n par de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". La serie de Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " se llama la serie de Fourier seno de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y viene dada por:\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n \[GreaterEqual] \ 1\)b\_n\ Sin[\[Pi]\ n\ \
t/L]\)]],
  "\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`b\_n = \(\(2\/L\) \(\[Integral]\_0\%L\( f(t)\) 
                Sin[\[Pi]\ n\ t/
                      L] \[DifferentialD]t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ n\) \
= 1\), 2,  ... \)]],
  " \nLa serie de Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " se llama la serie de Fourier coseno de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y viene dada por:\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`a\_0/
          2 + \[Sum]\+\(n \[GreaterEqual] 01\)a\_n\ Cos[\[Pi]\ n\ t/L]\)]],
  "\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`a\_n = \(\(2\/L\) \(\[Integral]\_0\%L\( f(t)\) 
                Cos[\[Pi]\ n\ t/
                      L] \[DifferentialD]t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ n\) \
= 0\), 1, 2,  ... \)]]
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Subsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define la extensi\[OAcute]n par y la extensi\[OAcute]n impar de ",
  Cell[BoxData[
      \(TraditionalForm\`f \((x)\) = 1 - x\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \([0, 1]\)\)]],
  ". Repres\[EAcute]ntalas gr\[AAcute]ficamente.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula los primeros 10 polinomios de las series de Fourier seno y coseno \
de ",
  StyleBox["f. \n",
    FontSlant->"Italic"],
  StyleBox["c)",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica representando la gr\[AAcute]fica \
de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " y sus primeros 10 polinomios seno en el intervalo [0,1].\n",
  StyleBox["d) ",
    FontWeight->"Bold"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica representando la gr\[AAcute]fica \
de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " y sus primeros 10 polinomios coseno en el intervalo [0,1].\n",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["e)",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "\[DownQuestion]Cu\[AAcute]l de las dos series aproxima mejor a ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "?"
}], "Text"],

Cell[BoxData[{
    \(f1[x_] := \(-1\) + x\^2 /; \(-1\) \[LessEqual] x < 
          0\), "\[IndentingNewLine]", 
    \(f1[x_] := 1 - x\^2\  /; 0 \[LessEqual] x < 1\), "\[IndentingNewLine]", 
    \(f2[x_] := 
      1 - x\^2 /; \(-1\) \[LessEqual] x < 0\), "\[IndentingNewLine]", 
    \(f2[x_] := 1 - x\^2 /; 0 \[LessEqual] x < 1\)}], "Input"],

Cell[BoxData[
    \(\(Plot[f1[x], {x, \(-1\), 1}, AspectRatio \[Rule] 1];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[f2[x], {x, \(-1\), 1}];\)\)], "Input"],

Cell[BoxData[{
    \(a[k_] := \(a[k] = 
        Simplify[
          2  Integrate[\((1 - t\^2)\) Cos[\[Pi]\ k\ t], {t, 0, 1}] /. TrigId, 
          k \[Element] \ Integers]\)\), "\[IndentingNewLine]", 
    \(b[k_] := \(b[k] = 
        Simplify[
          2  Integrate[\((1 - t\^2)\) Sin[\[Pi]\ k\ t], {t, 0, 1}] /. TrigId, 
          k \[Element] \ Integers]\)\)}], "Input"],

Cell[BoxData[
    \({a[0]/2, a[k], b[k]}\)], "Input"],

Cell[BoxData[
    \(Simplify[{a[0]/2, a[k], b[2  k], b[2  k + 1]} /. TrigId, 
      k \[Element] \ Integers]\)], "Input"],

Cell[BoxData[
    \(polinomiospares = 
      Table[a[0]/2 + \[Sum]\+\(k = 1\)\%n a[k]\ Cos[\ k\ \[Pi]\ t], {n, 1, 
          10}]\)], "Input"],

Cell[BoxData[
    \(polinomiosimpares = 
      Table[\ \[Sum]\+\(k = 1\)\%n b[k]\ Sin[\ k\ \[Pi]\ t], {n, 1, 
          10}]\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{1 - t\^2, polinomiosimpares[\([k]\)]}, {t, 0, 1}, 
        AspectRatio \[Rule] 1], {k, 1, 10}]\)], "Input"],

Cell[BoxData[
    \(Do[Plot[{1 - t\^2, polinomiospares[\([k]\)]}, {t, 0, 1}, 
        AspectRatio \[Rule] 1], {k, 1, 10}]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 34, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1813, 55, 39, 0, 93, "Section"],
Cell[1855, 57, 3694, 109, 222, "Text"],
Cell[5552, 168, 1812, 52, 118, "Text"],
Cell[7367, 222, 34, 0, 41, "Text"],
Cell[7404, 224, 1151, 32, 44, "Text"],
Cell[8558, 258, 187, 7, 42, "Text"],
Cell[8748, 267, 621, 11, 119, "Text"],
Cell[9372, 280, 1048, 23, 358, "Input"],
Cell[10423, 305, 139, 3, 41, "Text"],
Cell[10565, 310, 665, 12, 150, "Input"],
Cell[11233, 324, 269, 6, 86, "Text"],
Cell[11505, 332, 504, 10, 246, "Input"],
Cell[12012, 344, 74, 0, 41, "Text"],
Cell[12089, 346, 108, 2, 72, "Input"],
Cell[12200, 350, 284, 7, 67, "Text"],
Cell[12487, 359, 134, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[12646, 366, 29, 0, 78, "Subsection"],
Cell[12678, 368, 722, 16, 119, "Text"],
Cell[13403, 386, 134, 3, 41, "Text"],
Cell[13540, 391, 494, 10, 176, "Input"],
Cell[14037, 403, 505, 10, 93, "Text"],
Cell[14545, 415, 513, 10, 306, "Input"],
Cell[15061, 427, 189, 3, 124, "Input"],
Cell[15253, 432, 173, 3, 98, "Input"],
Cell[15429, 437, 206, 4, 136, "Input"],
Cell[15638, 443, 159, 2, 98, "Input"],
Cell[15800, 447, 1435, 32, 231, "Text"],
Cell[17238, 481, 2094, 40, 592, "Input"],
Cell[19335, 523, 139, 2, 72, "Input"],
Cell[19477, 527, 122, 2, 72, "Input"],
Cell[19602, 531, 61, 1, 72, "Input"],
Cell[19666, 534, 252, 6, 67, "Text"],
Cell[19921, 542, 62, 1, 72, "Input"],
Cell[19986, 545, 91, 1, 72, "Input"],
Cell[20080, 548, 87, 1, 72, "Input"],
Cell[20170, 551, 274, 7, 67, "Text"],
Cell[20447, 560, 239, 4, 98, "Input"],
Cell[20689, 566, 92, 1, 72, "Input"],
Cell[20784, 569, 89, 1, 72, "Input"],
Cell[20876, 572, 373, 8, 93, "Text"],
Cell[21252, 582, 151, 2, 98, "Input"],
Cell[21406, 586, 199, 4, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21642, 595, 33, 0, 78, "Subsection"],
Cell[21678, 597, 1070, 25, 201, "Text"],
Cell[22751, 624, 170, 3, 98, "Input"],
Cell[22924, 629, 331, 6, 150, "Input"],
Cell[23258, 637, 53, 1, 72, "Input"],
Cell[23314, 640, 103, 2, 72, "Input"],
Cell[23420, 644, 206, 4, 136, "Input"],
Cell[23629, 650, 155, 2, 98, "Input"],
Cell[23787, 654, 1327, 31, 180, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25151, 690, 33, 0, 78, "Subsection"],
Cell[25187, 692, 457, 13, 85, "Text"],
Cell[25647, 707, 54, 1, 72, "Input"],
Cell[25704, 710, 393, 8, 205, "Input"],
Cell[26100, 720, 53, 1, 72, "Input"],
Cell[26156, 723, 105, 2, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26298, 730, 33, 0, 78, "Subsection"],
Cell[26334, 732, 2492, 63, 503, "Text"],
Cell[28829, 797, 825, 16, 317, "Input"],
Cell[29657, 815, 606, 12, 317, "Input"],
Cell[30266, 829, 355, 7, 204, "Input"],
Cell[30624, 838, 326, 7, 204, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30987, 850, 33, 0, 78, "Subsection"],
Cell[31023, 852, 1233, 35, 177, "Text"],
Cell[32259, 889, 188, 3, 124, "Input"],
Cell[32450, 894, 142, 2, 98, "Input"],
Cell[32595, 898, 121, 3, 73, "Input"],
Cell[32719, 903, 128, 3, 73, "Input"],
Cell[32850, 908, 215, 3, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33102, 916, 33, 0, 78, "Subsection"],
Cell[33138, 918, 1991, 57, 411, "Text"],
Cell[35132, 977, 400, 6, 181, "Input"],
Cell[35535, 985, 324, 5, 181, "Input"],
Cell[35862, 992, 245, 5, 110, "Input"],
Cell[36110, 999, 237, 5, 110, "Input"],
Cell[36350, 1006, 157, 3, 73, "Input"],
Cell[36510, 1011, 213, 4, 99, "Input"],
Cell[36726, 1017, 77, 1, 73, "Input"],
Cell[36806, 1020, 76, 1, 73, "Input"],
Cell[36885, 1023, 91, 1, 73, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37025, 1030, 66, 0, 93, "Section"],
Cell[37094, 1032, 2590, 85, 407, "Text"],

Cell[CellGroupData[{
Cell[39709, 1121, 33, 0, 78, "Subsection"],
Cell[39745, 1123, 1277, 42, 193, "Text"],
Cell[41025, 1167, 340, 6, 151, "Input"],
Cell[41368, 1175, 88, 1, 72, "Input"],
Cell[41459, 1178, 65, 1, 72, "Input"],
Cell[41527, 1181, 373, 8, 202, "Input"],
Cell[41903, 1191, 53, 1, 72, "Input"],
Cell[41959, 1194, 121, 2, 72, "Input"],
Cell[42083, 1198, 142, 3, 104, "Input"],
Cell[42228, 1203, 137, 3, 104, "Input"],
Cell[42368, 1208, 136, 2, 99, "Input"],
Cell[42507, 1212, 134, 2, 99, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

